% AmirHosein Sadeghimanesh
% 2020 February, modified 2021 August
%
% In this script we sample several points uniformly from the approximation
% of the multistationarity region in Figure 8f. From each smallest yellow
% square we pick up 10 points, and from larger yellow rectangles we pick up
% an appropriate proportional number of points.
%
NN = 10; % Number of sample points from the smallest rectangle in Figure 8f which has area (volume) equal to (0.75)^2.
%
K = [3.75,2.5,5.0,3.75;
    1.25,1.25,1.875,1.875;
    1.875,1.875,2.5,2.5;
    2.5,1.875,3.125,2.5;
    3.125,1.875,3.75,2.5;
    2.5,2.5,3.125,3.125;
    3.125,2.5,3.75,3.125;
    3.125,3.125,3.75,3.75;
    3.75,3.75,4.375,4.375;
    4.375,3.75,5.0,4.375;
    4.375,4.375,5.0,5.0];
%
folder = 'C:\Home\PSS\Codes\Section_5_2'; % replace this directory to the directory of the folder you are using.
baseFileName = 'HK1v2p_sampling_from_bisect.txt';
fullFileName = fullfile(folder, baseFileName);
L1_file = fopen(fullFileName, 'w');
fprintf(L1_file, 'Sample points\n\n');

for idx1 = 1:size(K, 1)
    for idx2 = 1:floor(NN*((K(idx1, 3)-K(idx1, 1))/0.625)*((K(idx1, 4)-K(idx1, 2))/0.625))
        AA = sampleo(K(idx1, 1), K(idx1, 3));
        BB = sampleo(K(idx1, 2), K(idx1, 4));
        fprintf(L1_file, '%f,%f\n', AA, BB);
    end
end
fclose(L1_file);
%
% for purpose of timing we repeat the above process but without writing on
% a txt file. Since we are interested only in the time needed to generate
% the samples.
%
tic
for idx1 = 1:size(K, 1)
    for idx2 = 1:floor(NN*(K(idx1, 3)-K(idx1, 1))*(K(idx1, 4)-K(idx1, 2))/(0.75^2))
        AA = sampleo(K(idx1, 1), K(idx1, 3));
        BB = sampleo(K(idx1, 2), K(idx1, 4));
    end
end
toc
%
% Function to generate a random real number from a given interval.
%
function sampleo = sampleo(a, b)
    sampleo = a + (b-a) * rand;
end
%
% End of the file.